/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.getsentry.raven.RavenContext;
import shaded.com.getsentry.raven.connection.Connection;
import shaded.com.getsentry.raven.connection.LockedDownException;
import shaded.com.getsentry.raven.environment.RavenEnvironment;
import shaded.com.getsentry.raven.event.Event;
import shaded.com.getsentry.raven.event.EventBuilder;
import shaded.com.getsentry.raven.event.helper.EventBuilderHelper;
import shaded.com.getsentry.raven.event.interfaces.ExceptionInterface;

public class Raven {
    private static final Logger logger = LoggerFactory.getLogger(Raven.class);
    private static final Logger lockdownLogger = LoggerFactory.getLogger(Raven.class.getName() + ".lockdown");
    private static volatile Raven stored = null;
    private volatile Connection connection;
    private final Set<EventBuilderHelper> builderHelpers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ThreadLocal<RavenContext> context = new ThreadLocal<RavenContext>(){

        @Override
        protected RavenContext initialValue() {
            RavenContext ctx = new RavenContext();
            ctx.activate();
            return ctx;
        }
    };

    @Deprecated
    public Raven() {
        stored = this;
    }

    public Raven(Connection connection) {
        this.connection = connection;
        stored = this;
    }

    public void runBuilderHelpers(EventBuilder eventBuilder) {
        for (EventBuilderHelper builderHelper : this.builderHelpers) {
            builderHelper.helpBuildingEvent(eventBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(Event event) {
        try {
            this.connection.send(event);
        }
        catch (LockedDownException e) {
            lockdownLogger.warn("The connection to Sentry is currently locked down.", e);
        }
        catch (Exception e) {
            logger.error("An exception occurred while sending the event to Sentry.", e);
        }
        finally {
            this.getContext().setLastEventId(event.getId());
        }
    }

    public void sendEvent(EventBuilder eventBuilder) {
        this.runBuilderHelpers(eventBuilder);
        Event event = eventBuilder.build();
        this.sendEvent(event);
    }

    public void sendMessage(String message) {
        EventBuilder eventBuilder = new EventBuilder().withMessage(message).withLevel(Event.Level.INFO);
        this.runBuilderHelpers(eventBuilder);
        Event event = eventBuilder.build();
        this.sendEvent(event);
    }

    public void sendException(Throwable throwable) {
        EventBuilder eventBuilder = new EventBuilder().withMessage(throwable.getMessage()).withLevel(Event.Level.ERROR).withSentryInterface(new ExceptionInterface(throwable));
        this.runBuilderHelpers(eventBuilder);
        Event event = eventBuilder.build();
        this.sendEvent(event);
    }

    public void removeBuilderHelper(EventBuilderHelper builderHelper) {
        logger.debug("Removing '{}' from the list of builder helpers.", (Object)builderHelper);
        this.builderHelpers.remove(builderHelper);
    }

    public void addBuilderHelper(EventBuilderHelper builderHelper) {
        logger.debug("Adding '{}' to the list of builder helpers.", (Object)builderHelper);
        this.builderHelpers.add(builderHelper);
    }

    public Set<EventBuilderHelper> getBuilderHelpers() {
        return Collections.unmodifiableSet(this.builderHelpers);
    }

    public void closeConnection() {
        try {
            this.connection.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't close the Raven connection", e);
        }
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public RavenContext getContext() {
        return this.context.get();
    }

    public String toString() {
        return "Raven{name=" + RavenEnvironment.getRavenName() + ", connection=" + this.connection + '}';
    }

    public static Raven getStoredInstance() {
        return stored;
    }

    private static void verifyStoredInstance() {
        if (stored == null) {
            throw new NullPointerException("No stored Raven instance is available to use. You must construct a Raven instance before using the static Raven methods.");
        }
    }

    public static void capture(Event event) {
        Raven.verifyStoredInstance();
        Raven.getStoredInstance().sendEvent(event);
    }

    public static void capture(Throwable throwable) {
        Raven.verifyStoredInstance();
        Raven.getStoredInstance().sendException(throwable);
    }

    public static void capture(String message) {
        Raven.verifyStoredInstance();
        Raven.getStoredInstance().sendMessage(message);
    }

    public static void capture(EventBuilder eventBuilder) {
        Raven.verifyStoredInstance();
        Raven.getStoredInstance().sendEvent(eventBuilder);
    }
}

