/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.util.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import ru.turikhay.tlauncher.bootstrap.util.stream.ToStringBufferOutputStream;

class ByteArrayBufferOutputStream
extends ToStringBufferOutputStream {
    private static final int DEFAULT_MAX_COUNT = 0x400000;
    private volatile ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final Object lock = new Object();
    private final int maxCount;

    ByteArrayBufferOutputStream(int maxCount) {
        this.maxCount = maxCount;
    }

    ByteArrayBufferOutputStream() {
        this(0x400000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBuffer() {
        Object object = this.lock;
        synchronized (object) {
            return this.buffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBuffer() {
        Object object = this.lock;
        synchronized (object) {
            this.buffer.reset();
            this.buffer = new ByteArrayOutputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer.size() < this.maxCount) {
                this.buffer.write(b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer.size() < this.maxCount) {
                this.buffer.write(b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer.size() < this.maxCount) {
                this.buffer.write(b, off, len);
            }
        }
    }

    ByteArrayOutputStream buffer() {
        return this.buffer;
    }
}

