/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.ui.message;

import java.awt.Component;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JProgressBar;
import ru.turikhay.tlauncher.bootstrap.ui.message.MessagePanel;
import ru.turikhay.tlauncher.bootstrap.ui.message.TextMessage;

public class ProcessMessage
extends TextMessage {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Callable<Void> process;
    private Future<Void> future;

    public ProcessMessage(String text, Callable<Void> process) {
        super(text);
        this.process = process;
    }

    public ProcessMessage(String text, Runnable r) {
        this(text, () -> {
            r.run();
            return null;
        });
    }

    @Override
    void setupComponents(MessagePanel p) {
        super.setupComponents(p, true);
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        p.add((Component)progressBar, "South");
    }

    @Override
    protected void messageShown(MessagePanel panel) {
        this.future = executor.submit(this.process);
    }

    @Override
    protected void messageClosed(MessagePanel panel) {
        if (!this.future.isDone()) {
            this.future.cancel(true);
        }
        this.future = null;
    }
}

