/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ResourceBundle;
import ru.turikhay.tlauncher.bootstrap.ui.UserInterface;
import ru.turikhay.tlauncher.bootstrap.ui.message.Button;
import ru.turikhay.tlauncher.bootstrap.ui.message.MessageHost;
import ru.turikhay.tlauncher.bootstrap.ui.message.SingleButtonMessage;
import ru.turikhay.tlauncher.bootstrap.ui.message.TextAreaMessage;
import ru.turikhay.tlauncher.bootstrap.util.U;
import ru.turikhay.tlauncher.bootstrap.util.stream.OutputRedirectBuffer;
import shaded.org.apache.commons.io.IOUtils;

public class SaveLogsAction
implements Runnable {
    private final ResourceBundle b = UserInterface.getResourceBundle();
    private final MessageHost host;

    public SaveLogsAction(MessageHost host) {
        this.host = host;
    }

    @Override
    public void run() {
        this.saveLogs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLogs() {
        String content = SaveLogsAction.getLogsContent();
        File logsDir = new File(System.getProperty("user.home", "."), "bootstrap_logs");
        File file = new File(logsDir, "TL_bootstrap.log");
        OutputStreamWriter writer = null;
        try {
            if (!logsDir.isDirectory() && !logsDir.mkdir()) {
                throw new IOException("could not create directory: " + logsDir.getAbsolutePath());
            }
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            IOUtils.copy((Reader)new StringReader(content), (Writer)writer);
            writer.flush();
        }
        catch (IOException ioE) {
            U.log("[SaveLogs]", ioE);
            this.saveLogsFailed();
            return;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.host.showMessage(new SingleButtonMessage(this.b.getString("save-logs.success.text") + "<br/>" + this.b.getString("contacts"), Button.openFile(this.b.getString("save-logs.success.button"), file.getParentFile())));
    }

    private void saveLogsFailed() {
        this.host.showMessage(new TextAreaMessage(this.b.getString("save-logs.fail.text") + "<br/>" + this.b.getString("contacts"), SaveLogsAction.getLogsContent()));
    }

    private static String getLogsContent() {
        return OutputRedirectBuffer.getBuffer();
    }
}

