/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.turikhay.tlauncher.bootstrap.ui.EditorPane;
import ru.turikhay.tlauncher.bootstrap.ui.TextPopup;
import shaded.org.apache.commons.lang3.StringUtils;
import shaded.org.apache.commons.lang3.exception.ExceptionUtils;

class Alert {
    private static final String TITLE = "Alert";

    static void showError(String message, Object textarea) {
        Alert.show(0, message, textarea);
    }

    static void showWarning(String message, Object textarea) {
        Alert.show(2, message, textarea);
    }

    private static void show(int messageType, String message, Object textarea) {
        JOptionPane.showMessageDialog(null, new AlertPanel(message, textarea), TITLE, messageType);
    }

    private Alert() {
    }

    private static class AlertPanel
    extends JPanel {
        static final int width = 600;

        AlertPanel(String text, Object content) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.weightx = 1.0;
            c.gridy = -1;
            ++c.gridy;
            this.add(Box.createRigidArea(new Dimension(600, 1)), c);
            EditorPane label = new EditorPane("text/html", "<html><div width=\"600\">" + StringUtils.replace(text, "\n", "<br/>") + "</div></html>");
            ++c.gridy;
            this.add((Component)label, c);
            if (content != null) {
                ++c.gridy;
                this.add(Box.createRigidArea(new Dimension(600, 5)), c);
                String strContent = content instanceof Throwable ? ExceptionUtils.getStackTrace((Throwable)content) : String.valueOf(content);
                JTextArea textarea = new JTextArea();
                textarea.addMouseListener(new TextPopup());
                textarea.setWrapStyleWord(false);
                textarea.setLineWrap(true);
                textarea.setText(strContent);
                textarea.setEditable(false);
                JScrollPane scroll = new JScrollPane(textarea);
                scroll.setPreferredSize(AlertPanel.getPrefSize(strContent, 600, 300, textarea.getFontMetrics(textarea.getFont()), textarea.getInsets()));
                ++c.gridy;
                this.add((Component)scroll, c);
            }
        }

        private static Dimension getPrefSize(String str, int prefWidth, int maxHeight, FontMetrics metrics, Insets insets) {
            if (str == null || str.length() == 0) {
                return new Dimension(0, 0);
            }
            int len = str.length();
            int lines = 1;
            int lineWidth = 0;
            for (int pos = 0; pos < len; ++pos) {
                char c = str.charAt(pos);
                if ((lineWidth += metrics.charWidth(c)) <= prefWidth && c != '\n' && (c != '\r' || pos + 1 >= len || str.charAt(pos + 1) != '\n' || ++pos <= 0)) continue;
                ++lines;
                lineWidth = 0;
            }
            int height = metrics.getHeight() * lines + 2;
            if (height > maxHeight) {
                height = maxHeight;
            }
            return new Dimension(prefWidth, height += insets.top + insets.bottom);
        }
    }
}

