/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import ru.turikhay.tlauncher.bootstrap.Bootstrap;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.com.getsentry.raven.event.Event;
import shaded.com.getsentry.raven.event.EventBuilder;
import shaded.com.getsentry.raven.event.interfaces.ExceptionInterface;

public class FixSSL {
    private static boolean IS_FIXED = false;

    public static boolean isFixed() {
        return IS_FIXED;
    }

    public static void addLetsEncryptCertSupportIfNeeded() {
        try {
            FixSSL.addLetsEncryptIntoTrustStore();
        }
        catch (Exception e) {
            U.log("[FixSSL]", "Couldn't add LetsEncrypt root certificate", e);
            Bootstrap.SENTRY.sendEvent(new EventBuilder().withLevel(Event.Level.ERROR).withMessage("couldn't add LetsEncrypt root certificates").withSentryInterface(new ExceptionInterface(e)));
        }
    }

    private static boolean doesContainLetsEncryptRootCert(Map<String, Certificate> jreTrustStore, Map<String, Certificate> letsEncryptStore) {
        for (Certificate letsEncryptCert : letsEncryptStore.values()) {
            if (jreTrustStore.containsValue(letsEncryptCert)) continue;
            U.log("[FixSSL]", "JRE trust store doesn't contain", letsEncryptCert);
            return false;
        }
        return true;
    }

    private static void addLetsEncryptIntoTrustStore() throws Exception {
        Map<String, Certificate> letsEncryptStore;
        Map<String, Certificate> jreTrustStore = FixSSL.loadJreTrustStore();
        if (FixSSL.doesContainLetsEncryptRootCert(jreTrustStore, letsEncryptStore = FixSSL.loadLetsEncryptStore())) {
            return;
        }
        KeyStore mergedStore = FixSSL.mergeStores(jreTrustStore, letsEncryptStore);
        FixSSL.useNewKeyStoreGlobally(mergedStore);
        IS_FIXED = true;
    }

    private static Map<String, Certificate> loadJreTrustStore() throws Exception {
        File cacertsFile = new File(System.getProperty("java.home"), "lib/security/cacerts");
        return FixSSL.loadStore(new FileInputStream(cacertsFile), "changeit");
    }

    private static Map<String, Certificate> loadLetsEncryptStore() throws Exception {
        return FixSSL.loadStore(FixSSL.class.getResourceAsStream("lekeystore.jks"), "supersecretpassword");
    }

    private static KeyStore mergeStores(Map<String, Certificate> store0, Map<String, Certificate> store1) throws Exception {
        KeyStore mergedKeyStore = FixSSL.newKeyStore();
        mergedKeyStore.load(null, new char[0]);
        for (Map.Entry<String, Certificate> entry : store0.entrySet()) {
            mergedKeyStore.setCertificateEntry(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Certificate> entry : store1.entrySet()) {
            mergedKeyStore.setCertificateEntry(entry.getKey(), entry.getValue());
        }
        return mergedKeyStore;
    }

    private static void useNewKeyStoreGlobally(KeyStore keyStore) throws Exception {
        U.log("[FixSSL]", "Adding LetsEncrypt into trust store");
        TrustManagerFactory instance = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        instance.init(keyStore);
        SSLContext tls = SSLContext.getInstance("TLS");
        tls.init(null, instance.getTrustManagers(), null);
        HttpsURLConnection.setDefaultSSLSocketFactory(tls.getSocketFactory());
    }

    private static Map<String, Certificate> loadStore(InputStream input, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FixSSL.loadCAStore(keyStore, input, password);
        return FixSSL.readTrustStore(keyStore);
    }

    private static Map<String, Certificate> readTrustStore(KeyStore keyStore) throws KeyStoreException {
        HashMap<String, Certificate> result = new HashMap<String, Certificate>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate certificate = keyStore.getCertificate(alias);
            result.put(alias, certificate);
        }
        return result;
    }

    private static void loadCAStore(KeyStore keyStore, InputStream input, String password) throws IOException, CertificateException, NoSuchAlgorithmException {
        try {
            keyStore.load(input, password.toCharArray());
        }
        finally {
            input.close();
        }
    }

    private static KeyStore newKeyStore() throws KeyStoreException {
        return KeyStore.getInstance(KeyStore.getDefaultType());
    }

    private FixSSL() {
    }
}

