/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.launcher;

import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import ru.turikhay.tlauncher.bootstrap.launcher.LocalCastingLauncher;
import ru.turikhay.tlauncher.bootstrap.launcher.LocalLauncher;
import ru.turikhay.tlauncher.bootstrap.meta.RemoteLauncherMeta;
import ru.turikhay.tlauncher.bootstrap.task.DownloadTask;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;

public class RemoteLauncher
extends LocalCastingLauncher {
    private final RemoteLauncherMeta meta;

    public RemoteLauncher(RemoteLauncherMeta meta) {
        this.meta = Objects.requireNonNull(meta, "RemoteLauncherMeta");
    }

    @Override
    public Task<LocalLauncher> toLocalLauncher(final Path file, final Path libFolder) {
        return new Task<LocalLauncher>("remoteToLocalLauncher"){

            @Override
            protected LocalLauncher execute() throws Exception {
                this.log("Replacing local launcher with remote one");
                List<URL> urlList = Objects.requireNonNull(RemoteLauncher.this.meta.getDownloads(), "remoteLauncher download list");
                this.bindTo(new DownloadTask("remoteLauncherDownload", urlList, file, RemoteLauncher.this.meta.getChecksum()), 0.0, 1.0);
                return new LocalLauncher(file, libFolder);
            }
        };
    }

    @Override
    public RemoteLauncherMeta getMeta() {
        return this.meta;
    }

    @Override
    protected ToStringBuilder toStringBuilder() {
        return super.toStringBuilder().append("meta", this.meta);
    }
}

