/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.launcher;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import ru.turikhay.tlauncher.bootstrap.json.ToStringBuildable;
import ru.turikhay.tlauncher.bootstrap.task.DownloadTask;
import ru.turikhay.tlauncher.repository.RepoPrefixV1;
import shaded.com.google.gson.annotations.Expose;
import shaded.org.apache.commons.lang3.StringUtils;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;

public final class Library
extends ToStringBuildable {
    private static final List<String> LIBRARY_REPO_LIST = Collections.unmodifiableList(RepoPrefixV1.prefixesCdnLast().stream().map(prefix -> prefix + "/repo/libraries/").collect(Collectors.toList()));
    private String name;
    private String checksum;
    @Expose
    private String[] parts;

    public String getName() {
        return this.name;
    }

    public Path getFile(Path folder) {
        return Objects.requireNonNull(folder, "folder").resolve(this.getPath());
    }

    public DownloadTask downloadTo(Path dest) {
        return new DownloadTask(this.name, this.getUrlList(), dest, this.checksum);
    }

    public DownloadTask download(Path folder) {
        return this.downloadTo(this.getFile(folder));
    }

    private List<URL> getUrlList() {
        ArrayList<URL> urlList = new ArrayList<URL>();
        String path = this.getPath();
        for (String prefix : LIBRARY_REPO_LIST) {
            try {
                urlList.add(new URL(prefix + path));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return urlList;
    }

    private String getFilename() {
        String[] parts = this.getParts();
        if (parts.length == 4) {
            return String.format(Locale.ROOT, "%s-%s-%s.jar", parts[1], parts[2], parts[3]);
        }
        return String.format(Locale.ROOT, "%s-%s.jar", parts[1], parts[2]);
    }

    private String getBaseDir() {
        String[] parts = this.getParts();
        return String.format(Locale.ROOT, "%s/%s/%s", StringUtils.replaceChars(parts[0], '.', '/'), parts[1], parts[2]);
    }

    public String getPath() {
        return String.format(Locale.ROOT, "%s/%s", this.getBaseDir(), this.getFilename());
    }

    private String[] getParts() {
        if (this.parts == null) {
            this.parts = StringUtils.split(Objects.requireNonNull(this.name, "name"), ":", 4);
        }
        return this.parts;
    }

    @Override
    protected ToStringBuilder toStringBuilder() {
        return super.toStringBuilder().append("name", this.name).append("checksum", this.checksum);
    }
}

