/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.launcher;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import ru.turikhay.tlauncher.bootstrap.bridge.BootBridge;
import ru.turikhay.tlauncher.bootstrap.launcher.Library;
import ru.turikhay.tlauncher.bootstrap.launcher.LocalLauncher;
import ru.turikhay.tlauncher.bootstrap.task.Task;

public class ClassLoaderStarter {
    public static Task<Void> start(final LocalLauncher launcher, final BootBridge bridge) {
        Objects.requireNonNull(launcher, "LocalLauncher");
        return new Task<Void>("startLauncher"){

            @Override
            protected Void execute() throws Exception {
                ArrayList<URL> jarUrlList = new ArrayList<URL>();
                jarUrlList.add(launcher.getFile().toUri().toURL());
                Path libFolder = launcher.getLibFolder();
                for (Library lib : launcher.getMeta().getLibraries()) {
                    Path file = lib.getFile(libFolder);
                    if (!Files.isRegularFile(file, new LinkOption[0])) {
                        throw new FileNotFoundException("classpath is not found: " + file.toAbsolutePath());
                    }
                    jarUrlList.add(file.toUri().toURL());
                }
                for (URL url : jarUrlList) {
                    this.log("Classpath entry:", url);
                }
                URLClassLoader childCl = new URLClassLoader(jarUrlList.toArray(new URL[0]), this.getClass().getClassLoader());
                Class<?> clazz = Class.forName(launcher.getMeta().getMainClass(), true, childCl);
                Method method = clazz.getMethod("launch", BootBridge.class);
                try {
                    method.invoke(null, bridge);
                }
                catch (InvocationTargetException invokeException) {
                    if (invokeException.getCause() != null && invokeException.getCause() instanceof Exception) {
                        throw (Exception)invokeException.getCause();
                    }
                    throw invokeException;
                }
                return null;
            }

            @Override
            protected void interrupted() {
                bridge.setInterrupted();
            }
        };
    }
}

