/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.exception;

import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import ru.turikhay.tlauncher.bootstrap.exception.FileLockedException;
import ru.turikhay.tlauncher.bootstrap.launcher.LauncherNotFoundException;
import ru.turikhay.tlauncher.bootstrap.util.OS;

public enum FatalExceptionType {
    INTERNET_CONNECTIVITY_BLOCKED(t -> t instanceof SocketException && t.getMessage() != null && t.getMessage().startsWith("Address family not supported by protocol family") && OS.WINDOWS.isCurrent()),
    FILE_LOCKED(FileLockedException.class),
    CORRUPTED_INSTALLATION(ClassNotFoundException.class, NoClassDefFoundError.class),
    INTERNET_CONNECTIVITY(UnknownHostException.class, ConnectException.class, HttpRetryException.class, ProtocolException.class, SocketException.class, SocketTimeoutException.class, UnknownServiceException.class, LauncherNotFoundException.class),
    UNKNOWN(new AnyOther());

    private final TypeAssertion assertion;

    private FatalExceptionType(TypeAssertion assertion) {
        this.assertion = assertion;
    }

    private FatalExceptionType(Class<?> ... classes) {
        this(new ClassList(classes));
    }

    private boolean ensure(Throwable t) {
        if (t == null) {
            return false;
        }
        List<Throwable> list = Arrays.asList(t.getSuppressed());
        if (list.isEmpty()) {
            return this.assertion.ensure(t);
        }
        boolean allUnknown = true;
        for (Throwable e : list) {
            FatalExceptionType type = FatalExceptionType.getType(e);
            allUnknown &= type == UNKNOWN;
            if (type == UNKNOWN || type == this) continue;
            return false;
        }
        return !allUnknown || this.assertion.ensure(t);
    }

    public String nameLowerCase() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static FatalExceptionType getType(Throwable t) {
        for (FatalExceptionType type : FatalExceptionType.values()) {
            if (!type.ensure(t)) continue;
            return type;
        }
        return UNKNOWN;
    }

    static interface TypeAssertion {
        public boolean ensure(Throwable var1);
    }

    static class ClassList
    implements TypeAssertion {
        private final Class<?>[] classList;

        ClassList(Class<?> ... classList) {
            this.classList = classList;
        }

        @Override
        public boolean ensure(Throwable t) {
            Class<?> clazz = t.getClass();
            for (Class<?> checkClazz : this.classList) {
                if (!checkClazz.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }
    }

    static class AnyOther
    implements TypeAssertion {
        AnyOther() {
        }

        @Override
        public boolean ensure(Throwable t) {
            return true;
        }
    }
}

