/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import ru.turikhay.tlauncher.bootstrap.util.OS;
import ru.turikhay.tlauncher.bootstrap.util.U;

public class TargetConfig {
    private final Properties properties;

    public TargetConfig(Properties properties) {
        this.properties = properties;
    }

    public TargetConfig() {
        this(new Properties());
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.properties.getProperty(key));
    }

    public String getClient() {
        return this.get("client");
    }

    public boolean isSwitchToBeta() {
        return this.getBoolean("bootstrap.switchToBeta");
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean isFirstRun() {
        return this.getBoolean("firstRun");
    }

    public Map<String, String> asMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return map;
    }

    public static TargetConfig readConfigFromFile(Path file) {
        Properties properties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(file);){
            properties.load(reader);
        }
        catch (IOException e) {
            U.log("[TargetConfig]", "Couldn't read", file, e);
        }
        return new TargetConfig(properties);
    }

    public static Path getDefaultConfigFilePath(String brand) {
        return OS.getDefaultFolder().resolve(TargetConfig.brandToConfigFileName(brand) + ".properties");
    }

    private static String brandToConfigFileName(String brand) {
        return brand.startsWith("legacy") ? "legacy" : brand;
    }
}

