/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import ru.turikhay.tlauncher.bootstrap.Bootstrap;
import ru.turikhay.tlauncher.bootstrap.launcher.ProcessStarter;
import ru.turikhay.tlauncher.bootstrap.util.OS;
import ru.turikhay.tlauncher.bootstrap.util.U;
import ru.turikhay.util.JavaVersion;
import shaded.org.apache.commons.lang3.StringUtils;

public final class BootstrapStarter {
    public static void main(String[] args) throws Exception {
        int exitCode = BootstrapStarter.start(args, false);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    static int start(String[] args, boolean waitForClose) throws Exception {
        Path currentDir = Paths.get(System.getProperty("tlauncher.bootstrap.dir", "."), new String[0]);
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.addAll(BootstrapStarter.loadJvmArgs());
        jvmArgs.addAll(BootstrapStarter.loadExternalArgs(currentDir, "bootargs"));
        ArrayList<String> appArgs = new ArrayList<String>();
        Collections.addAll(appArgs, args);
        appArgs.addAll(BootstrapStarter.loadExternalArgs(currentDir, "args"));
        LinkedHashSet<Path> classPath = new LinkedHashSet<Path>(ProcessStarter.getDefinedClasspath());
        classPath.add(BootstrapStarter.getCurrentJar());
        Process process = ProcessStarter.startJarProcess(currentDir, classPath, Bootstrap.class.getName(), jvmArgs, appArgs).inheritIO().start();
        BootstrapStarter.log("Inherit process started");
        if (!waitForClose) {
            return 0;
        }
        return process.waitFor();
    }

    private static List<String> loadJvmArgs() {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.add("-Xmx128m");
        jvmArgs.add("-Dfile.encoding=UTF-8");
        jvmArgs.add("-Dtlauncher.systemCharset=" + Charset.defaultCharset().name());
        jvmArgs.add("-Dtlauncher.logFolder=" + OS.getSystemRelatedDirectory("tlauncher/logs", true));
        if (JavaVersion.getCurrent().getMajor() >= 9) {
            jvmArgs.add("--add-exports");
            jvmArgs.add("java.desktop/sun.awt=javafx.swing");
        }
        for (String propKey : System.getProperties().stringPropertyNames()) {
            if (!propKey.startsWith("tlauncher.bootstrap.")) continue;
            String value = Objects.requireNonNull(System.getProperty(propKey), "property \"" + propKey + "\"");
            String arg = "-D" + propKey + "=" + value;
            jvmArgs.add(arg);
            BootstrapStarter.log("Transferring property: ", arg);
        }
        return jvmArgs;
    }

    private static void addPossibleName(ArrayList<String> possibleNames, String name, String extension) {
        possibleNames.add("tl" + name + "." + extension);
        possibleNames.add("tlauncher" + name + "." + extension);
    }

    private static List<String> getPossibleExternalArgsFileNames(String extension) {
        ArrayList<String> possibleNames = new ArrayList<String>();
        BootstrapStarter.addPossibleName(possibleNames, "-" + OS.CURRENT.nameLowerCase() + "-" + OS.Arch.CURRENT.nameLowerCase(), extension);
        BootstrapStarter.addPossibleName(possibleNames, OS.CURRENT.nameLowerCase(), extension);
        BootstrapStarter.addPossibleName(possibleNames, "", extension);
        return possibleNames;
    }

    private static List<String> loadExternalArgs(Path currentDir, String extension) {
        Path externalArgsFile = null;
        for (String possibleName : BootstrapStarter.getPossibleExternalArgsFileNames(extension)) {
            Path file = currentDir.resolve(possibleName);
            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
            externalArgsFile = file;
            break;
        }
        if (externalArgsFile != null) {
            BootstrapStarter.log("Loading arguments from file:", externalArgsFile);
            try {
                return BootstrapStarter.loadArgsFromFile(externalArgsFile);
            }
            catch (IOException ioE) {
                BootstrapStarter.log("Cannot load arguments from file:", externalArgsFile, ioE);
            }
        }
        return Collections.emptyList();
    }

    private static List<String> loadArgsFromFile(Path file) throws IOException {
        List<String> lines = Files.readAllLines(file);
        lines.removeIf(StringUtils::isBlank);
        switch (lines.size()) {
            case 0: {
                throw new IOException("no lines found");
            }
            case 1: {
                return Arrays.asList(StringUtils.split(lines.get(0), ' '));
            }
        }
        lines.removeIf(line -> line.startsWith("#"));
        return lines;
    }

    private static Path getCurrentJar() throws URISyntaxException {
        return Paths.get(BootstrapStarter.class.getProtectionDomain().getCodeSource().getLocation().toURI());
    }

    private static void log(Object ... o) {
        U.log("[BootstrapStarter]", o);
    }
}

