/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.ui.swing;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BaseMultiResolutionImage;
import java.net.URL;
import javax.swing.ImageIcon;
import ru.turikhay.tlauncher.bootstrap.ui.swing.SwingImageIcon;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SwingImageIconImpl
implements SwingImageIcon {
    @Override
    public ImageIcon _loadIcon(URL url, int width, int height) {
        double scalingFactor = SwingImageIconImpl.queryScalingFactor();
        Image image = Toolkit.getDefaultToolkit().createImage(url);
        return new ImageIcon(new BaseMultiResolutionImage(image.getScaledInstance(width, height, 4), image.getScaledInstance((int)(scalingFactor * (double)width), (int)(scalingFactor * (double)height), 4)));
    }

    private static double queryScalingFactor() {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfig = graphicsDevice.getDefaultConfiguration();
        AffineTransform tx = graphicsConfig.getDefaultTransform();
        double scaleX = tx.getScaleX();
        double scaleY = tx.getScaleY();
        return Math.max(scaleX, scaleY);
    }
}

